from typing import Union
from dataclasses import dataclass

@dataclass
class BaseConfig:
    model_name: str = "gpt-4o-mini"
    # max_input_length: int = 4096
    # max_new_length: int = 2000

@dataclass
class ConfigCallGLM(BaseConfig):
    model_path: str = None
    # model_name: str = None
    eos_token_id: str = "</s>"
    
@dataclass
class ConfigCallAPI(BaseConfig):
    # api_path: str = './api_key_files/openai_api_key.txt'
    api_path: str = './api_key_files/openaihk_api_key.txt'
    # api_key: str = None
    # model_name: str = "gpt-4o"
    # base_url: str = "https://api.openai.com/v1"  # 默认为OpenAI API地址，可根据需要修改
    base_url: str = "https://api.openai-hk.com/v1/chat/completions"
    max_retries: int = 5
    retry_delay: int = 3
    # use_openai_api: bool = True
    use_openai_api: bool = False
    
@dataclass
class BaseConfigExtractor:
    model_config: Union[ConfigCallAPI, ConfigCallGLM] = None
    # 【输出设置】
    output_save_dir: str = f'./shot_play_scripts/'
    output_basename: str = ""
    unique_id: str = None
# 最终输出路径为 f'{output_save_dir}/{unique_id}_{output_basename}/...'
# eg.: './shot_play_scripts/2024-07-30-15-04-03_basename/plot_lines.docx'
# 你可以指定这三个参数让她每次都输出在同一目录（以前的会被覆盖）

    print_log: bool = True # 是否打印日志文件.log（默认为True，在ipynb里运行时建议关掉）

    load_data: bool = False # 是否从文件里断点续传（默认为False）
# 想断点续传需要指定output_save_dir和output_basename和unique_id为之前的工作目录
# 如果指定了存有数据的输出路径，但load_data=False，就可能会覆盖掉路径下原有的数据

@dataclass
class ConfigChapterExtractor(BaseConfigExtractor):
    # 【章节提取设置】
    chapter_setting: str = "chapter"

@dataclass
class ConfigGlobalExtract(BaseConfigExtractor):
    # model_config :Union[ConfigCallAPI, ConfigCallGLM] = None
    plot_lines_frag: Union[str, int] = "some"
    novel_path: str = None


@dataclass
class ConfigScriptRewriter(BaseConfigExtractor):
    # 【章节提取设置】
    rewriter_setting: str = "rewriter"